import tkinter as tk
from tkinter import messagebox
import mysql.connector

# Conectar a la base de datos MySQL
def conectar_db():
    try:
        conexion = mysql.connector.connect(
            host="localhost",
            user="tu_usuario_mysql",      # Cambia esto
            password="tu_contraseña_mysql", # Cambia esto
            database="mi_base_de_datos"
        )
        return conexion
    except mysql.connector.Error as err:
        messagebox.showerror("Error de conexión", f"No se pudo conectar a la base de datos: {err}")
        return None

# Función para agregar usuario a la base de datos
def agregar_usuario():
    conexion = conectar_db()
    if conexion:
        cursor = conexion.cursor()
        nombre = entrada_nombre.get()
        edad = entrada_edad.get()

        if nombre and edad:
            try:
                cursor.execute("INSERT INTO usuarios (nombre, edad) VALUES (%s, %s)", (nombre, int(edad)))
                conexion.commit()
                messagebox.showinfo("Éxito", "Usuario agregado correctamente")
                entrada_nombre.delete(0, tk.END)
                entrada_edad.delete(0, tk.END)
                mostrar_usuarios()
            except ValueError:
                messagebox.showerror("Error", "Por favor, ingrese una edad válida")
        else:
            messagebox.showerror("Error", "Por favor, complete todos los campos")
        
        conexion.close()

# Función para mostrar todos los usuarios en la lista
def mostrar_usuarios():
    lista_usuarios.delete(0, tk.END)
    conexion = conectar_db()
    if conexion:
        cursor = conexion.cursor()
        cursor.execute("SELECT * FROM usuarios")
        usuarios = cursor.fetchall()
        
        for usuario in usuarios:
            lista_usuarios.insert(tk.END, f"ID: {usuario[0]}, Nombre: {usuario[1]}, Edad: {usuario[2]}")
        
        conexion.close()

# Crear la ventana principal
ventana = tk.Tk()
ventana.title("Acceso a base de datos MySQL")
ventana.geometry("600x400")

# Etiqueta y entrada para el nombre
etiqueta_nombre = tk.Label(ventana, text="Nombre:")
etiqueta_nombre.pack(pady=5)
entrada_nombre = tk.Entry(ventana)
entrada_nombre.pack(pady=5)

# Etiqueta y entrada para la edad
etiqueta_edad = tk.Label(ventana, text="Edad:")
etiqueta_edad.pack(pady=5)
entrada_edad = tk.Entry(ventana)
entrada_edad.pack(pady=5)

# Botón para agregar usuario
boton_agregar = tk.Button(ventana, text="Agregar Usuario", command=agregar_usuario)
boton_agregar.pack(pady=10)

# Listbox para mostrar los usuarios
lista_usuarios = tk.Listbox(ventana, width=50, height=10)
lista_usuarios.pack(pady=20)

# Mostrar los usuarios existentes al iniciar
mostrar_usuarios()

# Iniciar el bucle principal
ventana.mainloop()
